/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Datum.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT Datum(IDesign *pDesign,IDrawingDocument *pDrawingdoc,IGraphic *pGraph1,IDatum **datum) 
{
	//	Creates a Datum
	START_METHOD("Datum")

	HRESULT status = CONV_SUCCESS;

	CHECK_VAR_STATUS(pDrawingdoc)

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pDrawingdoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	IDrawingDocOthers *doc1 = CAST(IDrawingDocOthers, pDrawingdoc);
	
	IDrawing *localDraw= NULL;
	status = activeDoc->GetDrawing(&localDraw);
	CHECK_RETURN_STATUS(status)	
	
	// get the design detail
	IDesignDetail *pDetail = NULL;
	status = localDraw->GetDetail(pDesign, FALSE,&pDetail);
	CHECK_RETURN_STATUS(status)	

	// get the paper geometry
	IGeometry *pGeom1 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1,&pGeom1);
	CHECK_RETURN_STATUS(status)	
	
	// create datum
	IDatum *localDatum1 = NULL;
	status = (GetCLASS(Datum))->CreateDatum(pDetail,pGeom1,&localDatum1);
	CHECK_RETURN_STATUS(status)	
	
	*datum = localDatum1 ;
	
	IDatumCallout *pCallout1 = NULL;
	status = (GetCLASS(DatumCallout))->CreateDatumCallout(localDatum1,&pCallout1);
	CHECK_RETURN_STATUS(status)	
	
	IVector *pTextlocation1 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.2, 0.2, 0, &pTextlocation1);
	CHECK_RETURN_STATUS(status)	
	
	// create callout group
	ICalloutGroup *localCalloutGroup1 = NULL;
	status = (GetCLASS(CalloutGroup))->CreateCalloutGroup(CAST(ICallout, pCallout1), pTextlocation1, 0.005,&localCalloutGroup1);
	CHECK_RETURN_STATUS(status)	
	
	status = localCalloutGroup1->SetControlPoint(1,pTextlocation1);
	CHECK_RETURN_STATUS(status)	
	
	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingdoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)
	
	status = pSheet->AddCalloutGroup(localCalloutGroup1);
	CHECK_RETURN_STATUS(status)	
	
	IGeometry *pGeom = NULL;
	status = localDatum1->GetGeometry(&pGeom);
	CHECK_RETURN_STATUS(status)	
	
	// create feature leader
	IFeatureLeader *pLeader1 = NULL;
	status = (GetCLASS(FeatureLeader))->CreateFeatureLeader(localCalloutGroup1, pGeom,&pLeader1);
	CHECK_RETURN_STATUS(status)	
	
	IVector *pNewPoint = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.1, 0.1, 0.1, &pNewPoint);
	CHECK_RETURN_STATUS(status)	
	
	ILeader *localLeader1 = CAST(ILeader, pLeader1);
	
	status = localLeader1->SetTerminationPoint(pNewPoint);
	CHECK_RETURN_STATUS(status)	
	
	status = localLeader1->SetPerpendicular();
	CHECK_RETURN_STATUS(status)	
	
	status = localLeader1->SetCalloutGroup(localCalloutGroup1);
	CHECK_RETURN_STATUS(status)	
	
	ICalloutGroup *pCalloutgroup2 = NULL;
	status = localLeader1->GetCalloutGroup(&pCalloutgroup2);
	CHECK_RETURN_STATUS(status)	
	
	status = localLeader1->SetTerminator(1);
	CHECK_RETURN_STATUS(status)	
	
	status = localLeader1->SetShoulderLength(0.1);
	CHECK_RETURN_STATUS(status)	
	
	status = localLeader1->RemoveJogPoints();
	CHECK_RETURN_STATUS(status)	
	
	status = pSheet->AddLeader(CAST(ILeader, pLeader1));
	CHECK_RETURN_STATUS(status)	
	
	// Add center line
	// To be done
	
	END_METHOD("Datum")
}
